﻿'///////////////////////////////////////////////////////////////////////
'
' UPDATED DEC 30, 2011 by Hazim Bitar to allow for Arduino/Servo communications.
' By: TechBitar/Hazim Bitar
'  Email: techbitar at gmail dot com
' This module provides sample code used to demonstrate the use
' of the KinectAudioSource for audio capture and beam tracking
'
' Copyright © Microsoft Corporation.  All rights reserved.  
' This code is licensed under the terms of the 
' Microsoft Kinect for Windows SDK (Beta) from Microsoft Research 
' License Agreement: http://research.microsoft.com/KinectSDK-ToU
'
'///////////////////////////////////////////////////////////////////////

'Arduino start
Imports System
Imports System.IO.Ports
'Arduino end

Imports System.Text
Imports Microsoft.Research.Kinect.Nui
Imports Coding4Fun.Kinect.Wpf

Namespace SkeletalTracking

	''' <summary>
	''' Interaction logic for MainWindow.xaml
	''' </summary>
	Partial Public Class MainWindow
		Inherits Window

        ' Arduino start
        Public Shared _continue As Boolean
        Public Shared _serialPort As SerialPort
        Public Shared ScreenMaxX As Integer = 180
        Public Shared ScreenMaxY As Integer = 180

        ' Arduino end

		Public Sub New()

			InitializeComponent()

		End Sub

		'Kinect Runtime
		Private nui As New Runtime

		Private Sub Window_Loaded(ByVal sender As Object, ByVal e As RoutedEventArgs)

                        
            'Initialize to do skeletal tracking
			nui.Initialize(RuntimeOptions.UseSkeletalTracking)

'			#Region "TransformSmooth"
			'Must set to true and set after call to Initialize
			nui.SkeletonEngine.TransformSmooth = True

			'Use to transform and reduce jitter
            Dim parameters = New TransformSmoothParameters With {.Smoothing = 0.8F, .Correction = 0.3F, .Prediction = 0.4F, .JitterRadius = 1.0F, .MaxDeviationRadius = 0.5F}

			nui.SkeletonEngine.SmoothParameters = parameters

'			#End Region

			'add event to receive skeleton data
            AddHandler nui.SkeletonFrameReady, AddressOf nui_SkeletonFrameReady

            '' Arduino start 
            ArduinoSetSerial()
            ArduinoOpenSerial()
            ' Arduino end
		End Sub

		Private Sub nui_SkeletonFrameReady(ByVal sender As Object, ByVal e As SkeletonFrameReadyEventArgs)

			Dim allSkeletons As SkeletonFrame = e.SkeletonFrame

			'get the first tracked skeleton
            Dim skeleton As SkeletonData = ( _
                From s In allSkeletons.Skeletons _
                Where s.TrackingState = SkeletonTrackingState.Tracked _
                Select s).FirstOrDefault()

            'TechBitar: The original Microsoft code was missing the "Not" which resulted in crashes. 
            If Not skeleton Is Nothing Then
                'set position

                SetEllipsePosition(headEllipse, skeleton.Joints(JointID.Head), JointID.Head)
                SetEllipsePosition(leftEllipse, skeleton.Joints(JointID.HandLeft), JointID.HandLeft)
                SetEllipsePosition(rightEllipse, skeleton.Joints(JointID.HandRight), JointID.HandRight)

                SendToArduino(skeleton.Joints(JointID.HandLeft), JointID.HandLeft)
                SendToArduino(skeleton.Joints(JointID.HandRight), JointID.HandRight)
            End If

        End Sub

        Private Sub SetEllipsePosition(ByVal ellipse As FrameworkElement, ByVal joint As Joint, ByVal JID As JointID)

            Dim scaledJoint = joint.ScaleTo(ScreenMaxX, ScreenMaxY, 0.5F, 0.2F)

            Canvas.SetLeft(ellipse, scaledJoint.Position.X)
            Canvas.SetTop(ellipse, scaledJoint.Position.Y)

        End Sub


        Private Sub SendToArduino(ByVal joint As Joint, ByVal JID As JointID)

            Dim scaledJoint = joint.ScaleTo(ScreenMaxX, ScreenMaxY, 0.5F, 0.2F)          

            If JID = JointID.HandRight Then
                HRKinectX.Text = scaledJoint.Position.X
                HRKinectY.Text = scaledJoint.Position.Y
               
            End If

            If JID = JointID.HandLeft Then
                HLKinectX.Text = scaledJoint.Position.X
                HLKinectY.Text = scaledJoint.Position.Y              
            End If

            ' Arduino start
            ArduinoSendByte(scaledJoint.Position.X, scaledJoint.Position.Y, 1, JID)
            ' Arduino end
         
        End Sub

		Private Sub Window_Closed(ByVal sender As Object, ByVal e As EventArgs)

			'Cleanup
			nui.Uninitialize()

        End Sub

        Private Sub ArduinoSetSerial()
            Dim ArduinoCom As String = ComPort.text
            _serialPort = New SerialPort()
            _serialPort.PortName = "COM" + Trim(ComPort.text)
            _serialPort.BaudRate = 9600
            ' _serialPort.Parity = 0
            _serialPort.DataBits = 8
            '  _serialPort.StopBits = 1
            _serialPort.Handshake = 0
            _serialPort.ReadTimeout = 500
            _serialPort.WriteTimeout = 500

        End Sub
        Private Sub ArduinoOpenSerial()
            If Not _serialPort.IsOpen Then
                _serialPort.Open()
            Else
                MsgBox("ARDUINO: SERIAL PORT CANNOT BE OPENED")
            End If
            _continue = True
        End Sub

        Private Sub ArduinoCloseSerial()
            If _serialPort.IsOpen Then
                _serialPort.Close()
            End If
        End Sub

        Private Sub ArduinoSendByte(ByVal kinect_x As Single, ByVal kinect_y As Single, ByVal kinect_z As Single, ByVal kinect_j As Integer)
            Dim x, y, z, j As Byte
            Dim sx, sy As Single
            Dim HowOften As Integer
            ComStatus.Text = "NA"           

            x = Math.Abs(CByte(kinect_x))
            y = Math.Abs(CByte(kinect_y))
            z = CByte(kinect_z)
            j = CByte(kinect_j)
            x = x
            Dim ArduinoBuffer() As Byte = {x, y, z, j}
            If _serialPort.IsOpen Then
                ComStatus.Text = "OK"
                _serialPort.Write(ArduinoBuffer, 0, ArduinoBuffer.Length)
            End If
        End Sub

	End Class

End Namespace
